<?php
/**
* French translations for Incubator plugins
* Translation: JC Richard aka anubis <jcrichard@lab-project.net>
*
* Installation: Copier le fichier en /components/com_comprofiler/plugin/language/fr-fr/
* Ouvrir le fichier /components/com_comprofiler/plugin/language/fr-fr/cbteamplugins_language.php
* En fin de fichier, ajouter la ligne:
* // Ajouter les traductions Incubator
* include( dirname( __FILE__ ) . '/incubator-cbteamplugins_language.php' ) ;
* Cette inclusion permet de mettre à jour très simplement les traductions incubator
*/
// Common strings. Those are common to most plugins.
CBTxt::addStrings( array(
	'Tools' => 'Outils',
	'Config' => 'Configuration',
	'Configuration' => 'Configuration',
	'Plugin' => 'Plugin',
	'Created' => 'Date de création',
	'Author' => 'Auteur',
	'License' => 'Licence',
	'Project' => 'Projet',
	'Access' => 'Accès',
	'Published' => 'Publié',
	'Version' => 'Version',
	'Description' => 'Description',
	'Copyright' => 'Copyright ©',
	'Create Menu' => 'Création du Menu',
	'Frontend URL' => 'Url publique',
	'ID' => 'ID',
	'Unknown' => 'Inconnu',
	'Move Up' => 'Monter',
	'Move Down' => 'Descendre',
	'User' => 'Utilisateur',
	'(required)' => '(obligatoire)',
	'Errors' => 'Erreurs',
	'Warnings' => 'Avertissements',
	'Info' => 'Informatif',
	'No errors were found.' => 'Aucune erreur détectée.',
	'No warnings were found.' => 'Aucun avertissement détecté.',
	'No info was found.' => 'Aucun message informatif détecté.',
	'New' => 'Nouveau',
	'Enable'        => 'Activer',
	'Disable'       => 'Désactiver',
	// Various common text
	'Field' => 'Champ',
	'Tab' => 'Onglet',
	'Fields' => 'Champs',
	'Tabs' => 'Onglets',
	'Search' => 'Recherche',
	'Category' => 'Catégorie',
	'None' => 'Aucun',
));

// CB Articles 1.0.6
CBTxt::addStrings( array(
	'General' => 'Général',
	'Template' => 'Template',
	'Select template to be used for all of CB Articles. If template is incomplete then missing files will be used from the default template. Template files can be located at the following location: [rel_path]/templates/' => 'Choisissez le template à utiliser pour CB Articles. Si le template est incomplet, les parties manquantes seront prises dans le template par défaut. Les fichiers templates sont installés à cet emplacement : [rel_path]/templates/',
	'Class' => 'Classe',
	'Optionally add a class suffix to surrounding DIV encasing all of CB Articles.' => 'Optionnellement, ajouter un suffixe de classe pour la DIV enveloppant CB Articles.',
	'Paging' => 'Pagination',
	'Enable or disable usage of paging on articles tab.' => 'Active ou désactive la pagination pour l\'onglet articles',
	'Limit' => 'Limites',
	'Enable or disable usage of limit (Display #) drop-down select box on articles tab. Requires Paging to be Enabled.' => 'Active ou désactive les limites (Afficher #) sur l\'onglet articles. Nécessite que la pagination soit active.',
	'Enable or disable usage of search on articles tab.' => 'Active ou désactive la recherche sur l\'onglet articles.',
	'Articles' => 'Articles',
	'Model' => 'Modèle',
	'Select articles model usage. Model determines where articles will be displayed from.' => 'Choisissez l\'utilisation du modèle articles. Le modèle détermine les affichages des articles.',
	'Exclude Sections' => 'Exlure les sections',
	'Select the CMS content sections that will be excluded from articles display.' => 'Choisissez les sections à exclure des affichages des articles. Sous Joomla! 1.7, une section est une catégorie racine.',
	'Excude Categories' => 'Exclure les catégories',
	'Select the CMS content categories that will be excluded from articles display.' => 'Choisissez les catégories à exclure des affichages des articles.',
	'No Section' => 'Sans section',
	'Enable or disable display of articles with no section.' => 'Active ou désactive l\'affichage des articles non inclus dans une section.',
	'No Category' => 'Non catégorisé',
	'Enable or disable display of articles with no category.' => 'Active ou désactive l\'affichage des articles non catégorisés.',
	'Auto Detect' => 'Détection automatique',
	'Joomla 1.0' => 'Joomla 1.0',
	'Joomla 1.5' => 'Joomla 1.5',
	'Joomla 1.7' => 'Joomla 1.7',
	'K2' => 'K2',
	'- Select Sections -' => '- Choix des sections -',
	'- Select Categories -' => '- Choix des catégories -',
	'Config failed to save! Error: [error]' => 'Echec de sauvegarde de la configuration. Erreur: [error]',
	'Config saved successfully!' => 'Configuration enregistrée.',
	'Search Articles...' => 'Recherche...',
	'Article' => 'Article',
	'Section' => 'Section',
	'No article search results found.' => 'La recherche n\'a renvoyé aucun résultat correspondant',
	'This user has no articles.' => 'Cet utilisateur n\'a publié aucun article.',
));

// CB Auto Actions 1.0.2
CBTxt::addStrings( array(
	'Auto Actions' => 'Auto Actions',
	'Type' => 'Type',
	'Triggers' => 'Déclencheurs',
	'State' => 'État',
	'Re-Order' => 'Reclasser',
	'Save Order' => 'Enregistrer le classement',
	'No auto action search results found.' => 'La recherche auto action ne retourne aucun résultat.',
	'There currently are no auto actions.'  => 'Aucune auto action n\'est définie.',
	'Auto Action: <small>Edit [[type]]</small>' => 'Auto Action: <small>Modifier [[type]]</small>',
	'Auto Action: <small>New</small>' => 'Auto Action: <small>Nouveau</small>',
	'Select publish status of auto action. Unpublished auto action will not execute.' => 'Choisissez l\'état de publication des auto actions. Une auto action non publiée ne sera pas exécutée.',
	'Select type of auto action. Type determines how an action executes.' => 'Choisissez le type de cette auto action. Le type détermine le mode d\'exécution de l\'action.',
	'Input comma seperated list of triggers or select trigger to append (e.g. onAfterLogin).' => 'Saisissez la liste des déclencheurs, séparés par des virgules ou choisissez un déclencheur (ex. onAfterLogin)',
	'Select if user object should be automatically obtained from trigger variables, if manually selected variable should be used (e.g. function login( $var1, $var2, $var3 ) {...), if user executing the trigger, or if specified user id should be used.' => 'Choissez si un objet utilisateur doit être obtenu automatiquement depuis les variables déclencheur ou si des variables choisies manuellement seront utilisées (ex fonction login( $var1, $var2, $var3 ) {...), si l\'identifiant utilisateur exécute le déclencheur ou si on doit utiliser un ID spécifique.',
	'Select access to auto action; only groups selected will have access. Parent groups such as Public Front-end will NOT fire for Registered users; exact groups must be selected.' => 'Choisissez l\'accès à auto action. Seuls le sgroupe ssélectionnés auront un accès. Les groupes parents, par exemple Public ne déclencheront pas l\'action destinée aux utilisateurs enregistrés. Les groupes EXACTS doivent être sélectionnés.',
	'Conditional' => 'Conditionnel',
	'Click and drag to move this conditional.' => 'Cliquez et glissez pour déplacer cette condition.',
	'Click to add new conditional.' => 'Cliquez pour ajouter une condition.',
	'Click to remove this conditional.' => 'Cliquez pour enlever cette condition.',
	'Optionally input substitution supported conditional from one value to another. If condition is not met then auto action will not be executed. At least one value (left or right side) and an operator must be specified for conditional to be valid. Additional conditionals can be added or remove using the + and - signs. Conditionals can also be re-ordered using drag and drop.' => 'Optionnellement, saisissez une condition utilisant les substitutions supportées de conversion d\'une valeur en une autre. Si la condition n\'est pas remplie, l\'action ne sera pas exécutée. Au moins une valeur (à gauche ou droite) et un oérateur doivent être précisés pour que la condition soit valide. Des conditions supplémentaires peuvent être ajoutées ou enlevées avec les signes + et -. Les conditions peuvent aussi être réorganisées par glisser-déposer.',
	'Exclude' => 'Exclure',
	'Optionally input comma seperated list of user ids to be excluded from auto action (e.g. 62,39,21,8).' => 'Optionnellement, vous pouvez saisir une liste d\'identifiants utilisateurs devant être exclus de cette action (ex. 62,39,21,8)',
	'General' => 'Général',
	'Input comma seperated list of user ids to be excluded from all auto actions (e.g. 62,39,21,8)' => 'Saisissez une liste d\'identifiants utilisateurs devant être exclus de cette action (ex. 62,39,21,8)',
	'- Select Type -' => '- Choix du type -',
	'- Select Access -' => '- Choix des accès -',
	'Custom ACL' => 'ACL personnalisé',
	'Everybody' => 'Tout le monde',
	'All Non-Registered Users' => 'Visiteurs non enregistrés',
	'All Registered Users' => 'Tous les utilisateurs enregistrés',
	'All Non-Moderators' => 'Tous les non modérateurs',
	'All Moderators' => 'Tous les modérateurs',
	'CMS ACL' => 'ACL du CMS',
	'- Select State -' => '- Choix de l\'état -',
	'- Add Trigger -' => '- Ajouter un déclencheur -',
	'Frontend' => 'Frontal',
	'Before User First Login' => 'Avant première connexion utilisateur',
	'Before Login Form Display' => 'Avant affichage du formulaire de connexion',
	'Before User Login' => 'Avant connexion utilisateur',
	'Login Authentication' => 'Authentification de la connexion',
	'During Login' => 'Durant la connexion',
	'Do Login Now' => 'Connecter maintenant',
	'After User Login' => 'Après connexion utilisateur',
	'Before User Logout' => 'Avant déconnexion utilisateur',
	'Do Logout Now' => 'Déconnecter maintenant',
	'After User Logout' => 'Après déconnexion utilisateur',
	'Before Avatar Update' => 'Avant mise à jour de l\'avatar',
	'Before Avatar Update' => 'Après mise à jour de l\'avatar',
	'Before Profile Edit Display' => 'Avant affichage modification du profil',
	'After Profile Edit Display' => 'Après affichage modification du profil',
	'Before Profile Update' => 'Avant mise à jour du profil',
	'After Profile Update' => 'Après mise à jour du profil',
	'Before Profile Request' => 'Avant requête du profil',
	'Before Profile Display' => 'Avant affichage du profil',
	'After Profile Display' => 'Après affichage du profil',
	'Before Registration Form Display' => 'Avant affichage du formulaire d\'inscription',
	'Before Registration Form' => 'Avant formulaire d\'inscription',
	'Start Save Registration' => 'Commencer l\'enregistrement de l\'inscription',
	'Before Registration' => 'Avant inscription',
	'After Registration' => 'Après inscription',
	'After Registration Mail Sent' => 'Après envoi de l\'email inscription',
	'Before Add Connection' => 'Avant ajout de connexion (ami)',
	'After Add Connection' => 'Après ajout de connexion (ami)',
	'Before Remove Connection' => 'Avant suppression de connexion (ami)',
	'After Remove Connection' => 'Après suppression de connexion (ami)',
	'Before Deny Connection' => 'Avant refus de connexion (ami)',
	'After Deny Connection' => 'Après refus de connexion (ami)',
	'Before Accept Connection' => 'Avant acceptation de connexion (ami)',
	'After Accept Connection' => 'Après acceptation de connexion (ami)',
	'Lost Password Form' => 'Formulaire Perdu mot de passe',
	'Start New Password' => 'Commencer nouveau mot de passe',
	'Before New Password' => 'Avant nouveau mot de passe',
	'New Password' => 'Nouveau mot de passe',
	'Before Username Reminder' => 'Avant rappel identifiant',
	'After Username Reminder' => 'Après rappel identifiant',
	'Before Email Form' => 'Avant formulaire email',
	'After Email Form' => 'Après formulaire email',
	'Before Email User' => 'Avant email utilisateur',
	'Before Userlist Display' => 'Avant affichage de la liste utilisateurs',
	'Backend' => 'Administration',
	'Before Delete User' => 'Avant suppression utilisateur',
	'After Delete User' => 'Après suppression utilisateur',
	'Before Blocking User' => 'Avant blocage utilisateur',
	'Before Sync User' => 'Avant synchro utilisateur',
	'After Sync User' => 'Après synchro utilisateur',
	'Before User Active' => 'Avant activation utilisateur',
	'After Check CB Database' => 'Après vérification de la base de données CB',
	'After Check Fields Database' => 'Après vérification des champs base de données',
	'Before Fix Database' => 'Avant réparation de la base de données',
	'After Fix Database' => 'Après réparation de la base de données',
	'Before Fix Fields Database' => 'Avant réparation des champs la base de données',
	'After Fix Fields Database' => 'Après réparation des champs la base de données',
	'Before Userlist Build Query' => 'Avant requête de construction de la liste utilisateurs',
	'Before Userlist' => 'Avant la liste utilisateurs',
	'Before Userlist Email Form' => 'Avant formulaire email à la liste utilisateurs',
	'Before Userlist Email Form Start' => 'Avant début formulaire email à la liste utilisateurs',
	'Before Userlist Email' => 'Avant email à la liste utilisateurs',
	'Frontend & Backend' => 'Frontal & Administration',
	'Before User Confirm' => 'Avant confirmation utilisateur',
	'After User Confirm' => 'Après confirmation utilisateur',
	'Before User Approval' => 'Avant approbation utilisateur',
	'After User Approval' => 'Après approbation utilisateur',
	'Prepare Menu' => 'Préparation du menu',
	'After Fields Fetch' => 'Après récupération des champs',
	'After Tabs Fetch' => 'Après récupération des onglets',
	'After Prepare Tabs View' => 'Après préparation d ela vue des onglets',
	'Before Tab Edit' => 'Avant modification onglet',
	'After Tab Edit' => 'Après modification onglet',
	'Start Userlist' => 'Commencer la liste utilisateurs',
	'After Userlist Fields SQL' => 'Après création requête SQL liste utilisateurs',
	'Before Userlist Build Query' => 'Avant construction de la requête liste utilisateurs',
	'Before Userlist Query' => 'Avant requête liste utilisateurs',
	'Field HTML Render' => 'Rendu HTML du champ',
	'Field Icons' => 'Icones du champ',
	'Log Change' => 'Log des modifications',
	'Automatic' => 'Automatique',
	'Manually' => 'Manuellement',
	'Specific' => 'Spécifique',
	'Variable 1' => 'Variable 1',
	'Variable 2' => 'Variable 2',
	'Variable 3' => 'Variable 3',
	'Variable 4' => 'Variable 4',
	'Variable 5' => 'Variable 5',
	'Variable 6' => 'Variable 6',
	'Variable 7' => 'Variable 7',
	'Variable 8' => 'Variable 8',
	'Variable 9' => 'Variable 9',
	'Variable 10' => 'Variable 10',
	'- Select Operator -' => '- Choix Opérateur -',
	'Equal To' => 'Egal à',
	'Not Equal To' => 'Non égal à',
	'Greater Than' => 'Supérieur à',
	'Less Than' => 'Inférieur à',
	'Greater Than or Equal To' => 'Supérieur ou égal à',
	'Less Than or Equal To' => 'Inférieur ou égal à',
	'Empty' => 'Vide',
	'Not Empty' => 'Non vide',
	'Does Contain' => 'Contient',
	'Does Not Contain' => 'Ne contient pas',
	'Is REGEX' => 'Est une expression rationnelle (REGEX)',
	'Is Not REGEX' => 'N\'est pas une expression rationnelle (REGEX)',
	'Type not specified!' => 'Type non précisé.',
	'Trigger not specified!' => 'Déclencheur non précisé.',
	'Access not specified!' => 'Accès non précisé.',
	'Specific user not specified!' => 'Utilisateur spécifique non précisé.',
	'User variable not specified!' => 'Variable utilisateur non précisée.',
	'Auto Action failed to save! Error: [error]' => 'Echec de sauvegarde Auto Action! Erreur: [error]',
	'Auto Action saved successfully!' => 'Auto Action enregistrée.',
	'Auto Action state failed to save! Error: [error]' => 'Echec de sauvegarde de l\'état Auto Action! Erreur: [error]',
	'Auto Action state saved successfully!' => 'Etat Auto Action enregistré.',
	'Auto Action not found.' => 'Auto Action introuvable!',
	'Auto Action order failed to save! Error: [error]' => 'Echec de sauvegarde de l\'ordre Auto Action! Erreur: [error]',
	'Auto Action order saved successfully!' => 'Ordre Auto Action enregistré.',
	'Auto Action failed to delete! Error: [error]' => 'Echec en suppression Auto Action! Erreur: [error]',
	'Auto Action deleted successfully!' => 'Auto Action supprimée.',
	'Auto Action failed to copy! Error: [error]' => 'Echec de la copie Auto Action! Erreur: [error]',
	'Auto Action copied successfully!' => 'Auto Action copiée.',
	'Config failed to save! Error: [error]' => 'Echec en sauvagarde de la configuration! Erreur: [error]',
	'Config saved successfully!' => 'Configuration enregistrée.',
	'Input comma seperated list of user ids to be excluded from all auto actions (e.g. 62,39,21,8).' => 'Saisissez une liste séparée par des virgules des ID utilisateurs à exclure de toute sles Auto Actions (ex. 62,39,21,8)',
	// Models
	// AUP
	'AlphaUserPoints' => 'AlphaUserPoints',
	'Synchronize user accounts to AlphaUserPoints and modifies users points.' => 'Synchroniser les comptes utilisateurs avec AlphaUserPoints et modifier les points utilisateurs.',
	'[action] Action' => 'Action [action]',
	'Points' => 'Points',
	'Input points value to adjust with positive and negative values supported (e.g. 3 or -3).' => 'Saisissez la valeur en points à ajuster avec des valeurs négatives ou positives (ex. 3 ou -3).',
	'Occurrences' => 'Occurrences',
	'Optionally input total number of occurrences of this auto action for a given user. If left blank then will be unlimited.' => 'Optionnellement, saisissez le nombre total d\'occurences de cette action pour un utilisateur donné. Si laissé à blanc, le nombre est illimité.',
	'Limit' => 'Limite',
	'Optionally input points limit. This determines the maximum points awarded from this trigger and is affected by interval. If left blank then no limit will be applied.' => 'Optionnellement, saisissez la limite en nombre de points. Ceci détermine le nombre maximal de points que peut allouer ce déclencheur, affecté par l\'intervalle donné. Si laissé à blanc, aucune limite ne sera appliquée.',
	'Interval' => 'Intervalle',
	'Optionally input limit interval in minutes. This determines the interval at which points can be awarded (e.g. 1440 for 1 day). If left blank then total points will be compared against.' => 'Optionnellement, saisissez la limite intervalle en minutes. Ceci détermine à quel intervalle des points peuvent être alloués (ex. 1440 pour 1 jour). Si à blanc, le total des points sera comapré et utilisé.',
	'[action] installation not found!' => '[action] installation introuvable!',
	'Points not specified!' => 'Points non précisés!',
	'Assign points based on Community Builder triggers: [trigger]' => 'Assigner des points sur la base des déclencheurs Community Builder: [trigger]',
	// Code
	'Code' => 'Code',
	'Executes POST, GET, XML, and JSON requests.' => 'Exécute des requêtes POST, GET, XML, et JSON',
	'Get' => 'Get',
	'Post' => 'Post',
	'XML' => 'XML',
	'JSON' => 'JSON',
	'Show' => 'Afficher',
	'Hide' => 'Cacher',
	'URL' => 'URL',
	'Input substitution supported URL (e.g. http://www.example.com/reciever.php).' => 'Saisissez une URL supportant les substitutions (ex. http://www.exemple.fr/receiver.php).',
	'Method' => 'Méthode',
	'Select URL request method.' => 'Choisissez la méthode de requête URL',
	'Request' => 'Requête',
	'Optionally input substitution supported request information to send with URL (e.g. GET: name=[name], POST: username=[username], XML: &lt;email&gt;[email]&lt;/email&gt;). Seperate additional variables with a linebreak.' => 'Optionnellement, saisisez les informations de requête à envoyer avec l\'URL (ex. GET name=[name], POST: username=[username], XML: &lt;email&gt;[email]&lt;/email&gt;). Séparez les variables aditionnelles par un saut de ligne.',
	'Return' => 'Retour',
	'Enable or disable display of return content. Not all triggers are capable of providing return content. Applies to frontend only and only if return content is present.' => 'Active ou désactive l\'affichage du contenu retourné. Tous les déclencheurs ne sont pas capables de fournir un contenu en retour. Ne s\'applique qu\'en frontal et uniquement si un contenu en retour est présent.',
	'Error' => 'Erreur',
	'Enable or disable display of return errors. Not all triggers are capable of providing return errors. Applies to frontend only and only if error is present.' => 'Active ou désactive l\'affichage des erreurs retournées. Tous les déclencheurs ne sont pas capables de fournir un retour en erreur. Ne s\'applique qu\'en frontal et uniquement si une erreur en retour est présente.',
	'Debug' => 'Débogage',
	'Enable or disable display of debug information. This will perform a dump of the entire request providing infomration such as results, errors, error codes, and more.' => 'Active ou désactive les affichages des informations de débogage. Provoque un dump global d ela requête avec les informations de retour, erreurs, codes erreur, et autres.',
	'URL not specified!' => 'URL non précisée!',
	'Method not specified!' => 'Méthode non précisée!',
	'Email' => 'Email',
	'Sends customized emails.' => 'Envoie des emails personnalisés.',
	'HTML' => 'HTML',
	'Text' => 'Texte',
	'To' => 'À',
	'Input substitution supported to address (e.g. [email]). Seperate multiple addresses with a comma (e.g. [email],bob@example.com).' => 'Saisissez l\'adresse destinataire avec support des substitutions (ex. [email]). Séparez des adresses multiples par des virgules (ex. [email],roger@exemple.fr).',
	'Subject' => 'Sujet',
	'Input substitution supported subject (e.g. [name]).' => 'Saisissez le sujet, supportant les substitutions (ex. Bonjour [name]).',
	'Body' => 'Corps',
	'Input substitution supported body.' => 'Saisissez le corps du message, supportant les substitutions.',
	'Mode' => 'Mode',
	'Select email mode. Mode determines how email body is processed.' => 'Choisissez le mode email. Le mode détermine comment le corps du message sera traité.',
	'CC' => 'CC',
	'Optionally input substitution supported cc address (e.g. [email]). Seperate multiple addresses with a comma (e.g. [email],bob@example.com).' => 'Optionnellement, saisissez une adresse copie carbone supportant les substitutions (ex. [email]). Séparez les adresses multiples par des virgules (ex. [email],director@martian.planet).',
	'BCC' => 'BCC',
	'Optionally input substitution supported bcc address (e.g. [email]). Seperate multiple addresses with a comma (e.g. [email],bob@example.com).' => 'Optionnellement, saisissez une adresse copie carbone cachée supportant les substitutions (ex. [email]). Séparez les adresses multiples par des virgules (ex. [email],director@martian.planet).',
	'Attachment' => 'Pièce jointe',
	'Optionally input substitution supported attachment absolute URL (e.g. /images/logo.png). Seperate multiple attachments with a comma (e.g. /images/logo.png,/images/license.pdf).' => 'Optionnellement, saisissez une liste d epièces jointes supportant les substitutions, avec une adresse absolue (ex. /images/logo.png). Séparez les pièces jointes multiples par des virgules (ex. /images/logo/png,/documents/licence.pdf,/documents/tarifs/tarif_revendeur.pdf).',
	'From Address' => 'De',
	'Optionally input substitution supported from address (e.g. bob@example.com).' => 'Optionnellement, saisissez une adresse d\'origine du mail supportant les substitutions (ex. planetmaster@martian.galaxy).',
	'From Name' => 'Nom expéditeur',
	'Optionally input substitution supported from name (e.g. bob).' => 'Optionnellement, saisisez un nom d\'expéditeur (ex. Webmaster).',
	'CC not a valid email address: [address]' => 'Adresse CC invalide: [address]',
	'BCC not a valid email address: [address]' => 'Adresse BCC invalide: [address]',
	'From address not a valid email address: [address]' => 'Adresse expéditeur invalide: [address]',
	'Subject not specified!' => 'Sujet non précisé.',
	'Body not specified!' => 'Corps de message non précisé.',
	'Mode not specified!' => 'Mode non précisé.',
	'To address not a valid email address: [address]' => 'Adresse destinatire invalide: [address]',
	'To address not specified!' => 'Adresse destinataire non précisée.',
	// Field
	'Adjust user field values.' => 'Ajuster les valeurs des champs utilisateurs',
	'- Select Field -' => '- Choix du champ -',
	'Set (Field = Value)' => 'Attribuer (Champ = Valeur)',
	'Prefix (ValueField)' => 'Préfixe (ValeurChamp)',
	'Suffix (FieldValue)' => 'Suffixe (ValeurChamp)',
	'Add (Field = Field + Value)' => 'Adition (Champ = Champ + Valeur)',
	'Subtract (Field = Field - Value)' => 'Soustraction (Champ = Champ - Valeur)',
	'Divide (Field = Field / Value)' => 'Division (Champ = Champ / Valeur)',
	'Multiply (Field = Field * Value)' => 'Multiplication (Champ = Champ * Valeur)',
	'Select field to alter.' => 'Choisissez le champ à altérer',
	'Operator' => 'Opérateur',
	'Select operator to apply to field value and value. Only integer fields can make use of an operator other then set, prefix, and suffix.' => 'Choisissez un opérateur à appliquer à la valeur du champ et sa valeur. Seuls les champs entiers supportent d\'autres opérateurs que Attribuer, préfixe et suffixe',
	'Value' => 'Valeur',
	'Input substitution supported field value (e.g. [user_id]).' => 'Valeur, supportant les substitutions (ex. [user_id])',
	'Field not specified!' => 'Champ non précisé.',
	'Operator not specified!' => 'Opérateur non précisé.',
	'Value not specified!' => 'Valeur non précisée.',
	// FlySpray
	'FlySpray' => 'FlySpray',
	'Synchronize user accounts to FlySpray.' => 'Synchroniser les comptes utilisateurs avec FlySpray',
	'No groups found!' => 'Aucun groupe trouvé.',
	'Database not configured!' => 'Base de données non configurée',
	'MD5' => 'MD5',
	'SH1' => 'SH1',
	'CRYPT' => 'CCRYPT',
	'Select FlySpray auto action mode. Mode determines what is performed during the auto action.' => 'Choisissez le mode FlySpray pour cette action. Le mode détermine ce qui sera réalisé durant l\'action.',
	'Group' => 'Groupe',
	'Optionally select FlySpray group of user. Requires database to be configured and auto action saved before results will display.' => 'Optionnellement, choisissez un groupe utilisateur FlySpray. Nécessite que la base de données soit configurée et cette action enregistrée pour voir les résultats.',
	'Encryption' => 'Cryptographie',
	'Select password encryption method used by FlySpray installation.' => 'Choisissez la méthode cryptographique utilisée par votre installation FlySpray.',
	'Database' => 'Base de données',
	'Host' => 'Serveur',
	'Input FlySpray database host (e.g. localhost).' => 'Saisissez le nom de serveur ou l\'adresse IP du serveur de base de données FlySpray',
	'Username' => 'Identifiant',
	'Input FlySpray database root username (e.g. root).' => 'Saisissez l\'identifiant utilisateur FlySpray (ex. root).',
	'Password' => 'Mot de passe',
	'Input FlySpray database root password (e.g. root).' => 'Saisissez le mot de passe utilisateur de la base de données FlySpray (ex. MonPassePerso).',
	'Input FlySpray database name (e.g. joomla).' => 'Saisissez le nom d evotre base de données FlySpray (ex. joomla17).',
	'Charset' => 'Jeu de caractères',
	'Optionally input FlySpray database charset (e.g. utf-8).' => 'Optionnellement, saisissez le jeu de caractères de la base FlySpray (ex utf8).',
	'Table Prefix' => 'Préfixe des tables',
	'Input FlySpray database table prefix (e.g. flyspray_). Prefix is used to replace #__ within queries.' => 'Saisissez le préfixe des tables FlySpray (ex. fly_). Le préfixe est utilisé pour le remplacement de #__ durant les requêtes.',
	'Mode not specified!' => 'Mode non précisé.',
	'Encryption not specified!' => 'Cryptographie non précisée.',
	'Database Host not specified!' => 'Serveur de bases de données non précisé',
	'Database Username not specified!' => 'Identifiant sur le serveur de bases de données non précisé.',
	'Database Password not specified!' => 'Mot de passe base de données non précisé.',
	'Database not specified!' => 'Base de données non précisée.',
	'Database Table Prefix not specified!' => 'Préfixe des tables non précisé.',
	// GroupJive
	'GroupJive 2.x' => 'GroupJive 2.x',
	'Create GroupJive 2.x categories and groups.' => 'Créer des catégories et groupes GroupJive 2.x.',
	'- Select Auto -' => '- Choix automate -',
	'Join Groups' => 'Rejoindre des groupes',
	'New Group' => 'Nouveau Groupe',
	'New Category' => 'Nouvelle catégorie',
	'No groups exist!' => 'Aucun groupe n\'existe.',
	'- Select Category -' => '- Choix de catégorie -',
	'No categories exist!' => 'Aucune catégorie existante.',
	'Banned' => 'Banni',
	'Inactive' => 'Inactif',
	'Active' => 'Actif',
	'Moderator' => 'Modérateur',
	'Admin' => 'Administrateur',
	'Owner' => 'Priopriétaire',
	'Open' => 'Ouvert',
	'Approval' => 'Approbation',
	'Invite' => 'Invitation',
	'Auto' => 'Automatisation',
	'Select type of auto. Auto determines what type of action is performed automatically.' => 'Choisissez le type d\'automatisation désiré. Détermine le type d\'action réalisée automatiquement.',
	'Groups' => 'Groupes',
	'Select groups to automatically join.' => 'Sélectionnez les groupes à rejoindre automatiquement.',
	'Status' => 'Etat',
	'Select status of the user for the specified groups.' => 'Choisissez l\'état utilisateur pour les groupes précisés.',
	'Select category for the new group.' => 'Choisissez la catégorie du nouveau groupe.',
	'Category Name' => 'Nom de la catégorie',
	'Input substitution supported new category (e.g. [username]).' => 'Saisissez le nom de la nouvelle catégorie, avec support des substitutions (ex. [username]).',
	'Category Description' => 'Description de la catégorie',
	'Optionally input substitution supported new category (e.g. [name]).' => 'Optionnellement, saisissez la description, avec support des substitutions (ex. [name]).',
	'Category Types' => 'Types catégorie',
	'Select categorys available group types. Types determine the way a groups is joined (e.g. Invite requires new users to be invited to join a group).' => 'Choisissez les types de groupes disponibles pour la catégorie. Les types déterminent les modalités pour rejoindre un groupe (par exemple, Invitation demande que les nouveaux membres soient invités à rejoindre le groupe).',
	'Category Unique' => 'Catégorie unique',
	'Select if category should be unique to the user. When checking if a category exists by name it will also check if exists by user id. If disabled only name is checked.' => 'Choisissez si la catégorie doit être unique pour l\'utilisateur. Lors de la vérification du nom de la catégorie, il sera également vérifié si elle existe pour cet ID utilisateur. Si désactivé, seulk le nom sera vérifié.',
	'Group Name' => 'Nom du groupe',
	'Input substitution supported new group (e.g. [username]).' => 'Saisissez le nom du nouveau groupe, avec support des substitutions (ex. [username]).',
	'Group Description' => 'Description du groupe',
	'Optionally input substitution supported new group (e.g. [name]).' => 'Optionnellement, saisissez une description du groupe, avec support des substitutions (ex. [name]).',
	'Group Type' => 'Type du groupe',
	'Select group type. Type determines the way your group is joined (e.g. Invite requires new users to be invited to join your group).' => 'Choisissez le type du groupe. Le type détermine les modalités de souscription au groupe (ex. Invitation requiert que vous invitiez les nouveaux utilisateur à rejoindre votre groupe).',
	'Group Unique' => 'Groupe unique',
	'Select if groups should be unique to the user. When checking if a group exists by name it will also check if exists by user id. If disabled only name is checked.' => 'Choisissez si les groupes sont uniques par utilisateur. Lors de la vérification de l\'existence du groupe par son nom, une vérification également par ID utilisateur est réalisée. Si désactivé, seul le nom est vérifié.',
	'Auto Join' => 'Rejoindre automatiquement',
	'Select if group should be automatically joined if duplicate found.' => 'Choisissez si ce groupe doit être automatiquement rejoint en cas de doublon de noms.',
	'[action] installation not found!' => '[action] installation introuvable!',
	'Auto not specified!' => 'Automatisation non précisée.',
	'Groups not specified!' => 'Groupes non précisés.',
	'Status not specified!' => 'Etat non précisé.',
	'Category not specified!' => 'Catégorie non précisée.',
	'Group Name not specified!' => 'Nom du groupe non précisé.',
	'Type not specified!' => 'Type non précisé.',
	'Category Name not specified!' => 'Nom de la catégorie non précisé.',
	'Types not specified!' => 'Types non précisés.',
	// Kunena 1.7
	'Kunena 1.7' => 'Kunena 1.7',
	'Creates Kunena forum categories.' => 'Creation de catégories forum Kunena.',
	'No Parent' => 'Pas de parent',
	'Parent' => 'Parent',
	'Select category parent.' => 'Choisissez la catégorie parente.',
	'Name' => 'Nom',
	'Input substitution supported category name.' => 'Saisissez le nom de la catégorie, avec support des substitutions.',
	'Optionally input substitution supported category description.' => 'Optionnellement, saisissez la description de la catégorie, avec support des substitutions.',
	'Name not specified!' => 'Nom non précisé.',
	// pms
	'Private Message' => 'Message privé',
	'Send customized private messages.' => 'Envoyer des messages privés personnalisés.',
	'From' => 'De',
	'Input substitution supported from user_id (e.g. [user_id]).' => 'Saisissez un identifiant expéditeur, avec support des substitutions (ex. [user_id]).',
	'To' => 'À',
	'Input substitution supported to user_id (e.g. [user_id]).' => 'Saisissez un identifiant destinataire, avec support des substitutions (ex. [user_id]).',
	'Subject' => 'Sujet',
	'Optionally input substitution supported subject (e.g. [name]). Please note not all PMS support subject usage.' => 'Optionnellement, saisissez un sujet, avec support des substitutions (ex. [name]). Attention, tous les systèmes de messagerie privée ne supportent pas les sujets.',
	'Message' => 'Message',
	'Input substitution supported message.' => 'Saisissez le message avec support des substitutions.',
	'From not specified!' => 'Expéditeur non précisé.',
	'To not specified!' => 'Destinataire non précisé.',
	'Message not specified!' => 'Corps du message vide.',
	// query
	'Query' => 'Requête',
	'Execute internal or external database queries.' => 'Exécute des requêtes sur base de données interne ou externe.',
	'External' => 'Externe',
	'Internal' => 'Interne',
	'Input substitution supported query. Seperate multiple queries with a ; followed by a linebreak (return/enter).' => 'Saisissez la requête SQL, avec support des substitutions. Séparez des requêtes multiples par des point-virgule (;) suivis par un saut de ligne (Touche Entrée).',
	'Mode' => 'Mode',
	'Select mode of query. The mode will determine what database the query is performed on.' => 'Choisissez le mode de requête. Le mode détermine quelle base de données est interrogée.',
	'Input external database host (e.g. localhost).' => 'Saisissez le nom du serveur externe (ex. localhost).',
	'Input external database root username (e.g. root).' => 'Saisissez le nom utilisateur sur le serveur externe (ex. root).',
	'Input external database root password (e.g. root).' => 'Saisissez le mot de passe sur le serveur distant (ex. MonPasse).',
	'Input external database name (e.g. joomla).' => 'Saisissez le nom de la base de données externe (ex. joomla).',
	'Optionally input external database charset (e.g. utf-8).' => 'Optionnellement, saisissez le jeu de caractères de la base externe (ex. utf8).',
	'Optionally input external database table prefix (e.g. jos_). Prefix is used to replace #__ within queries.' => 'Optionnellement, saisissez le préfixe des tables externes (ex. j17_). Le préfixe est utilisé pour remplacer les #__ dans les requêtes.',
	'Query not specified!' => 'Requête non définie.',
	'External Host not specified!' => 'Serveur externe non précisé.',
	'External Username not specified!' => 'Identifiant externe non précisé.',
	'External Password not specified!' => 'Mot de passe externe non précisé.',
	'External Database not specified!' => 'Base de données externe non précisée.',
	// redirect
	'Redirect' => 'Redirection',
	'Perform page redirects with or without messages.' => 'Realiser des redirections de pages, avec ou sans messages.',
	'Notice' => 'Information',
	'Note' => 'Note',
	'Attention' => 'Attention',
	'Alert' => 'Alerte',
	'Error' => 'Erreur',
	'Input substitution supported URL (e.g. index.php?option=com_comprofiler).' => 'Saisissez une URL avec support des substitutions (ex. index.php?option=com_comprofiler).',
	'Input substitution supported message to be included with redirect followed by selecting message type (e.g. Welcome [username]!). Message type determines display of message; format is template dependant and not guaranteed.' => 'Saisissez le message, avec support des substitutions, à inclure avec la redirection, suivi du choix du type de message (ex. Bienvenue [username]!). Le type de message détermine le format de présentation. Ce format dépend de votre template te ne peut être garanti.',
	'Select message display type. Type will determine the messages formatting.' => 'Choisissez le type de présentation. Le type détermine le format de mise en forme du message.',
	'URL not specified!' => 'URL non précisée.',
	'Message type not specified!' => 'Type de message non précisé.',
	// Virtuemart
	'VirtueMart 1.x' => 'VirtueMart 1.x',
	'Synchronize user accounts to VirtueMart.' => 'Synchroniser les comptes utilisateurs avec VirtueMart.',
	'- Select User Group -' => '- Choix du groupe utilisateurs -',
	'- Select Shopper Group -' => '- Choix du groupe clients -',
	'Address Type' => 'Type adresse',
	'Input default address type. Address type is required for synchronization to occur properly.' => 'Saisissez le type d\'adresse par défaut. Ce type est obligatoire pour que la synchronisation soit effectuée correctement.',
	'Address Name' => 'Nom adresse',
	'Input default address type name. Address name is required for synchronization to occur properly.' => 'Saisissez le nom du type adresse par défaut. Ce nom est obligatoire pour que la synchronisation soit réalisée correctement.',
	'User Group' => 'Groupe utilisateurs',
	'Optionally select user group to synchronize user to.' => 'Optionnellement, choisissez le groupe utilisateurs Joomla! vers lequel synchroniser l\'utilisateur.',
	'Shopper Group' => 'Groupe clients',
	'Optionally select shopper group to synchronize user to.' => 'Optionnellement, choisissez le groupe clients vers lequel synchroniser l\'utilisateur.',
	'Select fields to synchronize to [action] from Community Builder.' => 'Choisissez les champs à synchroniser à [action] depuis Community Builder.',
));

// CB Blogs 1.0.6:
CBTxt::addStrings( array(
	'Categories'    => 'Catégories',
	'Blogs Overview' => 'Accueil blogs',
	'Limit'         => 'Limites',
	'External'      => 'Externe',
	'Internal'      => 'Interne',
	'Paging'        => 'Pagination',
	'General'       => 'Générale',
	'Overview'      => 'Affichage',
	'Text'          => 'Texte',
	'Auto Detect'   => 'Automatique',
	'Enable'        => 'Activer',
	'Disable'       => 'Désactiver',
	'Intro & Full'  => 'Intro & Contenu',
	'Intro Only'    => 'Introduction seule',
	'Full Only'     => 'Contenu seul',
	'Icon'          => 'Icône',
	'Warnings'      => 'Avertissements',
	'Info'          => 'Informations',
	'Owner'         => 'Propriètaire',
	'Create Blog'	=> 'Créer un billet',
	'Access'		=> 'Accès',
	'Blog Intro'    => 'Introduction',
	'Blog Full'     => 'Contenu',
	'overview'      => 'affichage',
	'general_title' => 'Titre général',
	'Blog limit reached.' => 'Limite de recherche atteinte.',
	'Search Blogs...'     => 'Recherche...',
	'Not authorized.'     => 'Non autorisé',
	'- Select Section -'  => '- Sélectionner -',
	'- Select Access -'   => '- Sélectionner-',
	'- Select State -'    => '- Sélectionner-',
	'There currently are no blogs.'                => 'Il n\'y a pas de publication',
	'Frontend URL: [front_url]'                    => 'URL visible sur le site: [front_url]',
	'Login or Register to write blogs.'            => 'Identifiez-vous ou inscrivez-vous pour écrire sur les blogs',
	'Manage Your Blog'                             => 'Gérer votre Blog',
	'Manage your existing blogs and write new ones'=> 'Gérer vos billets blogs existants et écrivez-en d\'autres',
	// description
	'Select template to be used for all of CB Blogs. If template is incomplete then missing files will be used from the default template. Template files can be located at the following location: [rel_path]/templates/' => 'Choix du template à utiliser pour tous les CB Blogs. Si le template est incomplet, les fichiers manquants utiliseront le template par défaut. Les fichiers templates se trouvent à l\'emplacement suivant: [rel_path]/templates/',
	'Optionally add a class suffix to surrounding DIV encasing all of CB Blogs.' => 'Optionnel, suffixe de classe appliqué à la DIV encapsulant CB Blogs.',
	'Input title to be used in breadcrumb of CB Blogs.' => 'Titre à utiliser dans le fil d\'ariane CB Blogs.',
	'Select method for tooltip display. Applies to frontend only.' => 'Méthode d\'affichage des infobulles. Utilisée uniquement en frontal site.',
	'Enable or disable usage of CB Blogs menu link on CB Menu.' => 'Active/désactive le lien de menu CB Blogs dans le menu CB.',
	'Select logo to be used on Overview panel display. Logo images can be located at the following location: [rel_path]/images/' => 'Logo à utiliser en panneau présentation. Les images logos sont situées à l\'emplacement: [rel_path]/images/',
	'Optionally add description to be shown on Overview panel display.' => 'Optionnel, description à afficher en panneau présentation.',
	'Enable or disable usage of paging on Overview blogs.' => 'Active/désactive la pagination en vue d\'ensemble des blogs.',
	'Enable or disable usage of limit (Display #) drop-down select box on Overview blogs. Requires Paging to be Enabled.' => 'Active/désactive le sélecteur de limites de pagination (Afficher #) en vue d\'ensemble blogs. La pagination doit être activée.',
	'Enable or disable usage of search on Overview blogs.' => 'Active/désactive la recherche en vue d\'ensemble.',
	'Enable or disable usage of paging on Tab blogs.' => 'Active/désactive la pagination en onglets blogs.',
	'Enable or disable usage of limit (Display #) drop-down select box on Tab blogs. Requires Paging to be Enabled.' => 'Active/désactive le sélecteur de limites de pagination (Afficher #) en onglets blogs. La pagination doit être activée.',
	'Enable or disable usage of search on Tab blogs.' => 'Active/désactive la recherche en en onglets blogs.',
	'Select blog model usage. Model determines where blogs will be stored.' => 'Moèle. Le modèle détermine où les blogs seront enregistrés.',
	'Select blog mode usage. Mode determines how blogs are stored and displayed. Mode does not affect backend blog usage.' => 'Mode d\'utilisation des blogs. Le mode détermine le stockage et la présentation des blogs. Le mode n\'affecte pas le traitement en administration des blogs.',
	'Input number of blogs each individual user is limited to have active at any given time. If blank allow unlimited blogs.' => 'Nombre de blogs actifs autorisé par utilisateur. Laissez à blanc pour illimité.',
	'Input comma seperated list of internal categories (e.g. General, Movies, Family).' => 'Liste des catégories internes, séparées par des virgules (ex. Général, Cinéma, Famille).',
	'Select the external CMS content section where blogs will be stored as well as blog categories used.' => 'Choix de la section externe du CMS où les blogs seront enregistrés et où seront créées les catégories de blogs.',

	//Information et erreurs
	'Plugin menu created successfully!'                  => 'Création du Menu réalisé avec succès !',
	'Errors'                                             => 'Erreurs',
	'No errors were found.'                              => 'Aucune erreur détectée',
	'No warnings were found.'                            => 'Aucune mise en garde trouvée',
	'No info was found.'                                 => 'Aucune information disponible',
	'Blogs content section not specified!'               => 'Aucune section de blogs n\'est encore spécifiée!',
	'Blog deleted successfully!'                         => 'Blog supprimé avec succès!',
	'Blog failed to save! Error: [error]'                => 'Sauvegarde du Blog impossible! Erreur: [error]',
	'Blog state failed to save! Error: [error]'          => 'Sauvegarde du statut impossible à réaliser! Erreur: [error]',
	'Blog not found.'                                    => 'Aucun Blog disponible',
	'Blog failed to delete! Error: [error]'              => 'Suppresion du Blog impossible! Erreur: [error]',
	':: Blog :: Not published - [published]'             => ':: Blog :: Non publié - [published]',
	':: Blog :: Missing category - [category]'           => ':: Blog :: Catégorie manquante - [category]',
	':: Blog :: Missing section - [section]'             => ':: Blog :: Section manquante - [section]',
	':: Blog :: Missing access - [access]'               => ':: Blog :: Statut manquant - [access]',
	':: Blog :: Missing user - [user]'                   => ':: Blog :: Utilisateur manquant - [user]',
	':: Blog :: Missing title - [title]'                 => ':: Blog :: Titre manquant - [title]',
	'[config_url]'                                       => 'Configuration',
	'Config saved successfully!'                         => 'Configuration sauvegardée avec succès!',
	'Config failed to bind! Error: [error]'              => 'Configuration failed to bind! Erreur: [error]',
	':: Config :: Missing blog section - [config_url]'   => ':: Configuration :: Section manquante - [config_url]',
	':: Config :: Missing blog categories - [config_url]'=> ':: Configuration :: Catégorie manquante - [config_url]',
	':: Config :: No blog limit is set - [config_url]'   => ':: Configuration :: Limite manquante - [config_url]',

	//Models
	'Title not specified!'    => 'Titre non précisé.',
	'User not specified!'     => 'Utilisateur non précisé.',
	'Access not specified!'   => 'Accès non précisé.',
	'Category not specified!' => 'Catégorie non précisée.',

	//Templates
	//Edit
	'Select publish status of the blog. Unpublished blogs will not be visible to the public.'=> 'Sélectionnez le statut de publication du blog. Les Blogs non publiés ne sont pas visibles pour le public.',
	'Select blog category. Select the category that best describes your blog.'=> 'Sélectionnez la catégorie blog. Choisissez la catégorie qui décrit le mieux votre blog.',
	'Select access to blog; all groups above that level will also have access to the blog.'=> 'Sélectionnez le niveau d\'accès au blog; tous les groupes supérieurs à ce niveau auront également accès au blog.',
	'Input blog title. This is the title that will distinguish this blog from others. Suggested to input something unique and intuitive.'=> 'Titre du blog d\'entrée. C\'est le titre qui permettra de distinguer ce blog des autres. Choisissez un titre simple et explicite.',
	'Input HTML supported blog intro contents. Suggested to use minimal but well formatting for easy readability.'=> 'HTML pris en charge dans l\'introduction du contenu. Choisissez d\'utiliser un minimum de mise en forme, pour faciliter la lisibilité.',
	'Input HTML supported blog contents. Suggested to use minimal but well formatting for easy readability.'=> 'HTML pris en charge dans le contenu. Choisissez d\'utiliser un minimum de mise en forme, pour faciliter la lisibilité.',
	'Input owner of blog as single integer user_id.' => 'Propriétaire du blog (entier correspondant au user_id).',
	//Show
	'Written by [blog_author]'        => 'Ecrit par [blog_author]',
	'Last Modified on [blog_modified]'=> 'Dernière mise à jour le [blog_modified]',
	//Overview
	'Back to Profile'                              => 'Retour au Profil',
	'New Blog'                                     => 'Nouveau Blog',
	'Total: [blogs_total]'                         => 'Total: [blogs_total]',
	'Limit: [blogs_limit]'                         => 'Limite: [blogs_limit]' ,
	'Remaining: [blogs_remaining]'                 => 'Autres: [blogs_remaining]',
	'Are you sure you want to delete this Blog?'   => 'Etes-vous sûr de vouloir supprimer ce blog?',
	'Are you sure you want to unpublish this Blog?'=> 'Êtes-vous sûr de vouloir annuler la publication de ce blog!',
	'Category: [blog_category]'                    => 'Catégorie: [blog_category]',
	'Created: [blog_created]'                      => 'Crée: [blog_created]',
	'Title: [blog_title]'                          => 'Titre: [blog_title]',
	'No blog search results found.'                => 'Aucun résultat de recherche.',
	'You have no blogs.'                           => 'Vous n\'avez pas encore de blogs.',
	'This user has no blogs.'					  => 'Ce membre n\a pas encore créé de blog.',
));

// CB Conditional 1.1.2
CBTxt::addStrings( array(
	'Registration' => 'Inscription',
	'Please note Step by Step requires CB to use DIV layout (table-less).' => 'Note importante: le mode Pas à pas nécessite la configuration de Community Builder en affichage DIV (sans tables).',
	'Step by Step' => 'Pas à pas',
	'Enable or disable Registration step by step. Step by step allows fields display based off tabs in steps (If tab has 10 fields those 10 fields will be displayed in that step). Step titles all prefix with _REG_STEP followed by their count (e.g. _REG_STEP1) that can be defined within language strings (otherwise will display as Step 1, etc..). Tab registration order as defined in Tab Management during tab edit determines order of steps.' => 'Active ou désactive l\'inscription en mode pas à pas. Le mode pas à pas permet l\'affichage des champs sur la base d\'étapes définies, par étape (si l\'onglet contient 10 champs, ces 10 champs seront affichés durant cette étape). Les titres des étapes sont préfixés par _REG_STEP suivi de leur numéro d\'ordre (ex. _REG_STEP1, _REG_STEP2, etc) qui peuvent être définis par des chaînes langue (sinon l\'affichage sera Etape 1, etc.). L\'ordre des inscriptions par étapes tel que défini par l\'ordre des onglets durant la gestion des onglets détermine l\'ordre des étapes.',
	'Select template to be used on step by step Registration. If template is incomplete then missing files will be used from the default template. Template files can be located at the following location: [rel_path]/templates/' => 'Choisissez le template à utiliser durant les inscriptions par étapes. Si le template est incomplet, les fichiers manquants seront pris dans le template par défaut. Les fichiers templates sont accessible en: [rel_path]/templates/',
	'Validate' => 'Validation',
	'Enable or disable step Validation. Validate will cause input validation before proceeding to next step (e.g. username is required and click to Step 2 from Step 1 will cause validation error and can not proceed to next step).' => 'Active ou désactive la validation par étape. La validation par étape provoque la validation des saisies avant d epasser à l\'étape suivante (par exemple un identifiant est obligatoire et un clic vers Etape 2 depuis étape 1 causera une erreur si ce champ n\'est pas renseigné). La validation par étape permet un contrôle fin des champs.',
	':: Community Builder :: Table layout configured with step by step enabled - [cb_url]' => ':: Community Builder :: la présentation en mode table est choisie alors que le mode pas à pas est activé - [cb_url]',
	':: Config :: DIV layout configured with step by step disabled - [config_url]' => ':: Config :: la présentation DIV est configurée dans Coomunity Builder avec le mode pas à pas désactivé - [config_url]',
	':: Config :: Registration validation is not forced on a step by step process - [config_url]' => ':: Config :: La validation des inscriptions n\'est pas forcée en traitement pas à pas - [config_url]',
	':: Tab :: Missing field - [field]' => ':: Onglet :: Champ manquant - [field]',
	':: Tab :: Operator equal to empty value; operator empty suggested - [empty]' => ':: Onglet :: Opérateur retournant un résultat vide. Nous suggérons l\'opérateur vide - [empty]',
	':: Tab :: Operator not equal to empty value; operator not empty suggested - [notempty]' => ':: Onglet :: Opérateur retournant une valeur non vide. Utilisation d\'un opérateur non vide suggérée - [notempty]',
	':: Tab :: Is showing its self - [showself]' => ':: Onglet :: Affichage de l\'onglet lui même (self) - [showself]',
	':: Tab :: Is hiding its self - [hideself]' => ':: Onglet :: Se cache lui-même - [hideself]',
	':: Field :: Missing show and/or hide - [showhide]' => ':: Champ :: Manque afficher et/ou cacher - [showhide]',
	':: Field :: Operator equal to empty value; operator empty suggested - [empty]' => ':: Champ :: Opérateur renvoyant une valeur vide. Utilisation de l\'opérateur vide suggérée - [empty]',
	':: Field :: Operator not equal to empty value; operator not empty suggested - [notempty]' => ':: Champ :: Opérateur renvoyant une valeur non vide. Utilisation de l\'opérateur non vide suggérée  - [notempty]',
 	':: Field :: Is showing its self - [showself]' => ':: Champ :: S\'affiche lui-même - [showself]',
 	 ':: Field :: Is hiding its self - [hideself]' =>  ':: Champ :: Se cache lui-même - [hideself]',
 	 ':: Field :: Is setting its self as required - [reqself]' => ':: Champ :: Se positionne lui-même en obligatoire - [reqself]',
 	 ':: Field :: Is setting its self as non-required - [nonreqself]' => ':: Champ :: Se positionne lui-même en non obligatoire - [nonreqself]',
	'- Select Fields -' => '- Choix des champs -',
	'Step ' => 'Etape ',
	'Next' => 'Etape suivante',
	'Previous' => 'Etape précédente',
	'Register' => 'Enregistrer',
)) ;

/**
* Specific defines allowing translation for step registration
*/
if ( !defined( '_REG_STEP1' ) ) {
define( '_REG_STEP1', 'Etape 1' );
define( '_REG_STEP2', 'Etape 2' );
define( '_REG_STEP3', 'Etape 3' );
define( '_REG_STEP4', 'Etape 4' );
define( '_REG_STEP5', 'Etape 5' );
define( '_REG_STEP6', 'Etape 6' );
define( '_REG_STEP7', 'Etape 7' );
define( '_REG_STEP8', 'Etape 8' );
define( '_REG_STEP9', 'Etape 9' );
define( '_REG_STEP10', 'Etape 10' );
}

// CBInvites 1.0.3
CBTxt::addStrings( array(
	'Resend' => 'Réexpédier',
	'Invites' => 'Invitations',
	'Search Invites...' => 'Rechercher dans les invitations...',

	'Manage Your Invites' => 'Gérer vos invitations',
	'Manage your existing invites and send new ones for [sitename]' => 'gérer vos invitation existantes à vous rejoindre sur [sitename] et lancer de nouvelles invitations',
	'Not authorized.' => 'Non autorisé.',
	'Comma seperated lists are not supported! Please use a single To address.' => 'Les adresses multiples séparées par des virgules ne sont pas autorisées. Veuillez utiliser une seule adresse destinataire.',
	'Invite limit reached.' => 'Vous avez atteint votre limite en nombre d\'invitations.',
	'Invite failed to bind.' => 'Invitation impossible à gérer.',
	'To address missing.' => 'Adresse destinataire manquante.',
	'To address not valid: [to_address]' => 'Adresse destinataire invalide: [to_address]',
	'You can not invite your self.' => 'Vous ne pouvez vous inviter vous-même!',
	'To address is already a user.' => 'Le destinataire est déjà membre du site.',
	'You have already invited: [to_address]' => 'Vous avez déjà invité [to_address]',
	'Invite failed to send.' => 'Erreur en envoi de cette invitation.',
	'Invite failed to save.' => 'Erreur en enregistrement de cette invitation.',
	'Invite saved successfully!' => 'Invitation enregistrée.',
	'Invite sent successfully!' => 'Invitation envoyée.',
	'Invite already accepted.' => 'Invitation déjà acceptée !',
	'Invite resend not applicable at this time.' => 'La réexpédition est inapplicable pour le moment. Retentez plus tard.',
	'Invite failed to delete! Error: [error]' => 'Erreur en suppression d ecette invitation. Erreur: [error]',
	'Invite deleted successfully!' => 'Invitation supprimée.',

	'<p>You have been invited by [username] to join [sitename]!</p><br />' => '<p>[username] vous invite à le(la) rejoindre sur [sitename]!</p><br />',
	'<br /><p>[sitename] - [site]<br />Registration - [register]<br />[username] - [profile]</p>' => '<br /><p>[sitename] - [site]<br />Inscription - [register]<br />[username] - [profile]</p>',
	'Join Me!' => 'Rejoins moi!',
	'<strong>To:</strong> %s' => '<strong>A:</strong> %s',
	'<strong>State:</strong> %s' => '<strong>Etat:</strong> %s',
	'<strong>Sent:</strong> %s' => '<strong>Envoyé:</strong> %s',
	'Resend' => 'Réenvoyer',
	'No invite search results found.' => 'Aucun résultat à cette recherche sur les invitations.',
	'You have no invites.' => 'Vous n\'avez pas encore envoyé une invitation.',
	'Please note edited invites will not resend upon saving.' => 'Note: Les invitations modifiées ne sont pas réexpédiées avant d\'être enregistrées.',
	'Are you sure you want to delete this invite?' => 'Etes-vous certain de vouloir supprimer cette invitation ?',
	'Accepted' => 'Accepté',
	'Pending' => 'En attente',
	'<strong>Accepted:</strong> %s' => '<strong>Accepté:</strong> %s',
	'Are you sure you want to cancel? All unsaved data will be lost!' => 'Etes-vous certain de vouloir annuler ? Toutes les informations non enregistrées seront perdues.',
	'Create Invite' => 'Nouvelle invitation',
	'Invites Overview' => 'Mes invitations',
	'Input invite email to address.' => 'Adresse e-mail du destinataire',
	'Subject' => 'Sujet',
	'Input invite email subject; if left blank a subject will be applied.' => 'Objet de votre e-mail. Si vous ne mettez rien, un sujet par défaut sera créé.',
	'Header' => 'En tête',
	'Content applied to the beginning of the invite email (before Body).' => 'Contenu appliqué au début du message (avant le texte principal du message)',
	'Body' => 'Corps',
	'Input private message to include with invite email.' => 'Un message privé pour le destinataire, à inclure avec votre invitation.',
	'Footer' => 'Fin de message',
	'Content applied to the end of the invite email (after Body).' => 'Contenu inséré à la fin du message (après votre message privé)',
	'Input owner of invite as single integer user_id.' => 'Propriétaire de cette invitation sous forme de nombre entier (user_id). Si vous ne savez pas ce que cette option signifie, ne mettez rien et laissez la valeur existante.',
	'Save' => 'Enregistrer',
	'New Invite' => 'Nouvelle invitation',
	'Invited: %s' => 'Invités: %s',
	'Accepted: %s' => 'Acceptés: %s',
	'Pending: %s' => 'En attente: %s',
	'Limit: %s' => 'Limite: %s',
	'Unlimited' => 'Illimité',
	'Remaining:' => 'Reste:',
	'(required)' => '(Obligatoire)',

));

// CB Connect 1.1.0
CBTxt::addStrings( array(
	'Link your Friend Connect account.' => 'Lier votre compte Friend Connect.',
	'Link' => 'Lien',
	'Login with your Friend Connect account.' => 'Connexion avec votre compte Friend Connect',
	'Sign in' => 'Connexion',
	'View Google Profile' => 'Voir le profil Google',
	'View users Friend Connect profile.' => 'Voir le profil Friend Connect',
	'Send Invite' => 'Envoyer une invitation',
	'Invite users to join with Friend Connect.' => 'Inviter des utilisateurs via Friend Connect',
	'Update Google Settings' => 'Mettre à jour les paramètres Google',
	'View and Edit Friend Connect Settings' => 'Afficher et modifier les paramètres Friend Connect',
	'Link your Facebook account.' => 'Lier votre compte Facebook',
	'Login with your Facebook account.' => 'Connexion avec votre compte Facebook',
	'Unjoin this site' => 'Délier ce site',
	'Unauthorize this site from your Facebook account.' => 'Supprimer l\'autorisation de ce site sur votre compte Facebook',
	'Link your Twitter account.' => 'Lier votre compte Twitter',
	'Login with your Twitter account.' => 'Connexion avec votre compte Twitter',
	'View Twitter Profile' => 'Voir le profil Twitter',
	'View users Twitter profile.' => 'Voir le profil utilisateur Twitter.',
	'Link your LinkedIn account.' => 'Lier votre compte LinkedIn.',
	'Login with your LinkedIn account.' => 'Connexion avec votre compte LinkedIn.',
	'View Friend Connect Profile' => 'Voir le profil Friend Connect',
	'Sign up for our newsletter!' => 'Inscrivez-vous à notre newsletter!',
	'Get email updates featuring our sites latest content' => 'Recevez par e-mail les mises à jour de nos sites.',
	'Featured Content' => 'Contenu en vedette',
	'Recommend it!' => 'Recommander!',
	'Did you like this page?' => 'Avez-vous aimé cette page&nbsp;?',
	'- add your review here -' => '- ajoutez votre critique ici -',
	'Ratings' => 'Notes',
	'- add your comment here -' => '- ajoutez votre commentaire ici -',
	'Comments' => 'Commentaires',
	'View Facebook Profile' => 'Voir le profil Facebook',
	'Friend' => 'Ami',
	'You have been invited to join [site_url]!' => 'Vous êtes invité à rejoindre [site_url]!',
	'Website' => 'Site web',
	'Invite your friends from Facebook.' => 'Inviter vos amis Facebook.',
	'[cb:userfield field="formatname" /] Profile Page' => '[cb:userfield field="formatname" /] Profil',
	'Tweet' => 'Tweet',
	'What\'s happening?' => 'Que se passe t\'il&nbsp;?',
	'Follow @[screen_name]' => 'Suivre @[screen_name]',
	'View LinkedIn Profile' => 'Voir le profil LinkedIn',
	'ID already in use or account mismatch!' => 'Identifiant déjà utilisé ou erreur de compte!',
	'Account linked successfully.' => 'Le compte est lié.',
	'Account linking not permitted!' => 'Lien du compte non autorisé!',
	'Account registration not permitted!' => 'Inscription du compte non autorisée!',
	'User failed to initiate!' => 'Echec en initialisation pour cet utilisateur.',
	'This username is already in use!' => 'Cet identifiant est déjà utilisé!',
	'Are you sure you want to unjoin [live_site]?' => 'Etes-vous certain de vouloir délier [live_site]&nbsp;?',
	'Connected' => 'Connecté',
	'- Select Type -' => '- Choix du type -',
	'Friend Connect' => 'Friend Connect',
	'Facebook' => 'Facebook',
	'Twitter' => 'Twitter',
	'LinkedIn' => 'LinkedIn',
	'Default CMS' => 'CMS par défaut',
	'No (override CB)' => 'Non (surcharge CB)',
	'Yes (override CB)' => 'Oui (surcharge CB)',
	'Default (CB setting)' => 'Par défaut (paramètres CB)',
	'- Select Community Builder Field -' => '- Choix du champ Community Builder -',
	'- Select Friend Connect Field -' => '- Choix du champ Friend Connect -',
	'ID' => 'ID',
	'Display Name' => 'Identifiant',
	'Profile Picture' => 'Photo du profil',
	'Automatic (CB Language)' => 'Automatique (Langue CB)',
	// pas termine (admin.cbconnect)
)) ;
